/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge;

import com.endertech.minecraft.forge.ForgeLocating;
import com.endertech.minecraft.forge.units.IForgeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class ForgeRendering {
    public static void setLightmapTextureCoords(int combinedLight) {
        int x = combinedLight % 65536;
        int y = combinedLight / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)x, (float)y);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void setLightmapTextureCoords(World world, BlockPos pos, int minLight) {
        int combinedLight = world.func_175626_b(pos, minLight);
        ForgeRendering.setLightmapTextureCoords(combinedLight);
    }

    public static void renderItemLayerIn2D(int width, int height, float thickness, float minX, float minY, float maxX, float maxY, float minU, float minV, float maxU, float maxV, double layerOffsetX, double layerOffsetY, double layerOffsetZ) {
        double v;
        double y;
        double u;
        double x;
        int i;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        double x1 = (double)minX + layerOffsetX;
        double x2 = (double)maxX - layerOffsetX;
        double y1 = (double)minY + layerOffsetY;
        double y2 = (double)maxY - layerOffsetY;
        double z1 = 0.0 - layerOffsetZ;
        double z2 = layerOffsetZ - (double)thickness;
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(x1, y1, z1).func_187315_a((double)minU, (double)minV).func_181675_d();
        buffer.func_181662_b(x2, y1, z1).func_187315_a((double)maxU, (double)minV).func_181675_d();
        buffer.func_181662_b(x2, y2, z1).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        buffer.func_181662_b(x1, y2, z1).func_187315_a((double)minU, (double)maxV).func_181675_d();
        tessellator.func_78381_a();
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(x1, y2, z2).func_187315_a((double)minU, (double)maxV).func_181675_d();
        buffer.func_181662_b(x2, y2, z2).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        buffer.func_181662_b(x2, y1, z2).func_187315_a((double)maxU, (double)minV).func_181675_d();
        buffer.func_181662_b(x1, y1, z2).func_187315_a((double)minU, (double)minV).func_181675_d();
        tessellator.func_78381_a();
        float halfPixelWidth = 0.5f * (minU - maxU) / (float)width;
        float halfPixelHeight = 0.5f * (minV - maxV) / (float)height;
        GL11.glNormal3f((float)-1.0f, (float)0.0f, (float)0.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (i = 0; i < width; ++i) {
            x = (float)i / (float)width;
            u = (double)minU + (double)(maxU - minU) * x - (double)halfPixelWidth;
            x = x1 + (double)i * ((double)(maxX - minX) - 2.0 * layerOffsetX) / (double)width;
            buffer.func_181662_b(x, y1, z2).func_187315_a(u, (double)minV).func_181675_d();
            buffer.func_181662_b(x, y1, z1).func_187315_a(u, (double)minV).func_181675_d();
            buffer.func_181662_b(x, y2, z1).func_187315_a(u, (double)maxV).func_181675_d();
            buffer.func_181662_b(x, y2, z2).func_187315_a(u, (double)maxV).func_181675_d();
        }
        tessellator.func_78381_a();
        GL11.glNormal3f((float)1.0f, (float)0.0f, (float)0.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (i = 0; i < width; ++i) {
            x = (float)i / (float)width;
            u = (double)minU + (double)(maxU - minU) * x - (double)halfPixelWidth;
            x = x1 + (double)((float)i + 1.0f) * ((double)(maxX - minX) - 2.0 * layerOffsetX) / (double)width;
            buffer.func_181662_b(x, y2, z2).func_187315_a(u, (double)maxV).func_181675_d();
            buffer.func_181662_b(x, y2, z1).func_187315_a(u, (double)maxV).func_181675_d();
            buffer.func_181662_b(x, y1, z1).func_187315_a(u, (double)minV).func_181675_d();
            buffer.func_181662_b(x, y1, z2).func_187315_a(u, (double)minV).func_181675_d();
        }
        tessellator.func_78381_a();
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (i = 0; i < height; ++i) {
            y = (float)i / (float)height;
            v = (double)minV + (double)(maxV - minV) * y - (double)halfPixelHeight;
            y = y1 + (double)((float)i + 1.0f) * ((double)(maxY - minY) - 2.0 * layerOffsetY) / (double)height;
            buffer.func_181662_b(x1, y, z1).func_187315_a((double)minU, v).func_181675_d();
            buffer.func_181662_b(x2, y, z1).func_187315_a((double)maxU, v).func_181675_d();
            buffer.func_181662_b(x2, y, z2).func_187315_a((double)maxU, v).func_181675_d();
            buffer.func_181662_b(x1, y, z2).func_187315_a((double)minU, v).func_181675_d();
        }
        tessellator.func_78381_a();
        GL11.glNormal3f((float)0.0f, (float)-1.0f, (float)0.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (i = 0; i < height; ++i) {
            y = (float)i / (float)height;
            v = (double)minV + (double)(maxV - minV) * y - (double)halfPixelHeight;
            y = y1 + (double)i * ((double)(maxY - minY) - 2.0 * layerOffsetY) / (double)height;
            buffer.func_181662_b(x2, y, z1).func_187315_a((double)maxU, v).func_181675_d();
            buffer.func_181662_b(x1, y, z1).func_187315_a((double)minU, v).func_181675_d();
            buffer.func_181662_b(x1, y, z2).func_187315_a((double)minU, v).func_181675_d();
            buffer.func_181662_b(x2, y, z2).func_187315_a((double)maxU, v).func_181675_d();
        }
        tessellator.func_78381_a();
    }

    public static void renderBlock(double x, double y, double z, double width, double height, double length, double rotateX, double rotateY, double rotateZ, double red, double green, double blue, double alpha) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179091_B();
        GlStateManager.func_179114_b((float)((float)rotateX), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)rotateY), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)rotateZ), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179139_a((double)width, (double)height, (double)length);
        GlStateManager.func_179131_c((float)((float)red), (float)((float)green), (float)((float)blue), (float)((float)alpha));
        GlStateManager.func_187447_r((int)9);
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_187435_e((float)-0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_187435_e((float)-0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_187435_e((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_187435_e((float)0.5f, (float)0.5f, (float)-0.5f);
        GlStateManager.func_187435_e((float)-0.5f, (float)0.5f, (float)-0.5f);
        GlStateManager.func_187437_J();
        GL11.glBegin((int)9);
        GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_187435_e((float)0.5f, (float)-0.5f, (float)0.5f);
        GlStateManager.func_187435_e((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_187435_e((float)-0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_187435_e((float)-0.5f, (float)-0.5f, (float)0.5f);
        GlStateManager.func_187437_J();
        GL11.glBegin((int)9);
        GlStateManager.func_187432_a((float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_187435_e((float)0.5f, (float)0.5f, (float)-0.5f);
        GlStateManager.func_187435_e((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_187435_e((float)0.5f, (float)-0.5f, (float)0.5f);
        GlStateManager.func_187435_e((float)0.5f, (float)-0.5f, (float)-0.5f);
        GlStateManager.func_187437_J();
        GL11.glBegin((int)9);
        GlStateManager.func_187432_a((float)-1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_187435_e((float)-0.5f, (float)-0.5f, (float)0.5f);
        GlStateManager.func_187435_e((float)-0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_187435_e((float)-0.5f, (float)0.5f, (float)-0.5f);
        GlStateManager.func_187435_e((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GlStateManager.func_187437_J();
        GL11.glBegin((int)9);
        GlStateManager.func_187432_a((float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_187435_e((float)0.5f, (float)-0.5f, (float)0.5f);
        GlStateManager.func_187435_e((float)-0.5f, (float)-0.5f, (float)0.5f);
        GlStateManager.func_187435_e((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GlStateManager.func_187435_e((float)0.5f, (float)-0.5f, (float)-0.5f);
        GlStateManager.func_187437_J();
        GL11.glBegin((int)9);
        GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)-1.0f);
        GlStateManager.func_187435_e((float)0.5f, (float)0.5f, (float)-0.5f);
        GlStateManager.func_187435_e((float)0.5f, (float)-0.5f, (float)-0.5f);
        GlStateManager.func_187435_e((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GlStateManager.func_187435_e((float)-0.5f, (float)0.5f, (float)-0.5f);
        GlStateManager.func_187437_J();
        GlStateManager.func_179121_F();
    }

    public static class MeterIndicators {
        public static final ResourceLocation TEXTURE = ForgeLocating.itemTexture("forgeendertech", IForgeUnit.getClassRegName(MeterIndicators.class), new String[0]);

        public static void beforeRender(float meterThickness) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(-meterThickness / 2.0f));
            GlStateManager.func_179140_f();
            GlStateManager.func_179129_p();
            TextureManager manager = Minecraft.func_71410_x().func_110434_K();
            manager.func_110577_a(TEXTURE);
        }

        public static void afterRender() {
            GlStateManager.func_179145_e();
            GlStateManager.func_179089_o();
            GlStateManager.func_179121_F();
        }
    }
}

